using System;
using System.Data;
using System.Data.SqlTypes;
using System.Data.SqlClient;
using MethodBase = System.Reflection.MethodBase;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>08/05/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// Address data access layer class.
	///</summary>

	#endregion
	
	public class CTRatioReport
	{

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>08/05/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2068"> 
		///		<ExpectedInput>Dates, Division, Multi-Division indicator</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2069"> 
		///		<ExpectedInput>Invalid Division</ExpectedInput>
		///		<ExpectedOutput>0</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetCTRatioReportCount
		/// </summary>
		/// <param name="startDate">Start Date</param>
		/// <param name="endDate">End Date</param>
		/// <param name="divisionCode">Division code</param>
		/// <param name="multiDivisional"> Multi divisional indicator</param>
		/// <returns>Count</returns>
		public static int GetCTRatioReportCount(DateTime startDate, DateTime endDate, string divisionCode, bool multiDivisional)
		{
			int count = 0;
			//
			SqlParameter [] prms = 
				{
					new SqlParameter(STOREDPROC.GetCrossmatchedUnitsInDateRangeCount.startdate, System.Data.SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetCrossmatchedUnitsInDateRangeCount.enddate, System.Data.SqlDbType.DateTime),
					new SqlParameter(STOREDPROC.GetCrossmatchedUnitsInDateRangeCount.divisioncode, System.Data.SqlDbType.Char),
					new SqlParameter(STOREDPROC.GetCrossmatchedUnitsInDateRangeCount.multidivisional, System.Data.SqlDbType.Bit)
				};
			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = divisionCode;
			prms[3].Value = multiDivisional;
			//
			DataTable dt = StoredProcedure.GetData(STOREDPROC.GetCrossmatchedUnitsInDateRangeCount.StoredProcName, prms).Tables[0];
			foreach(DataRow dr in dt.Rows)
			{
				count += (int)dr["Total"];
			}
			//
			return count;
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>08/05/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="2070"> 
		///		<ExpectedInput>Dates, Division, Multi-Division indicator</ExpectedInput>
		///		<ExpectedOutput>DataTable of Crossmatch details</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="2072"> 
		///		<ExpectedInput>Invalid Division</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetCTRatioReport
		/// </summary>
		/// <param name="startDate">Start Date</param>
		/// <param name="endDate">End Date</param>
		/// <param name="divisionCode">Division code</param>
		/// <param name="multiDivisional"> Multi divisional indicator</param>
		/// <returns>Data table of specimen test information</returns>
		public static DataTable GetCTRatioReport(DateTime startDate, DateTime endDate, string divisionCode, bool multiDivisional)
		{
			SqlParameter [] prms = 
			{
				new SqlParameter(STOREDPROC.GetCrossmatchedUnitsInDateRange.startdate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetCrossmatchedUnitsInDateRange.enddate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetCrossmatchedUnitsInDateRange.divisioncode, System.Data.SqlDbType.Char),
				new SqlParameter(STOREDPROC.GetCrossmatchedUnitsInDateRange.multidivisional, System.Data.SqlDbType.Bit)
			};
			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = divisionCode;
			prms[3].Value = multiDivisional;

			DataTable dt = Common.StoredProcedure.GetData(STOREDPROC.GetCrossmatchedUnitsInDateRange.StoredProcName, prms).Tables[0];
			dt.TableName = "DetailedReport";
			return dt;
		}

	}
}
